package coreservlets.filters;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Obiekt przechowujcy odpowied, czyli wszystkie dane, ktre zwraca klient.
 *  Dane te zostaj zapisane w jednym duym cigu znakw.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class StringWrapper
             extends HttpServletResponseWrapper {
  private StringWriter stringWriter;

  /** Inicjalizacja obiektu przechowujcego.
   *  <P>
   *  Najpierw konstruktor wywouje konstruktor rodzica.
   *  To wywoanie ma kluczowe znaczenie, by mc zapisa odpowied
   *  i setHeader, setStatus, addCookie i im podobne dziaay prawidowo.
   *  <P>
   *  Nastpnie konstruktor tworzy obiekt StringWriter,
   *  ktry zostanie uyty do zbierania danych odpowiedzi.
   */

  public StringWrapper(HttpServletResponse response) {
    super(response);
    stringWriter = new StringWriter();
  }

  /** Gdy serwlety lub strony JSP zadaj obiektu Writer,
   *  nie otrzymaj prawdziwego obiektu. W zamian zwrcona
   *  zostanie wersja zapisujca dane do bufora StringBuffer.
   *  Filtr musi przesa zawarto bufora do klienta
   *  (zazwyczaj po wykonaniu w niej odpowiednich zmian).
   */

  public PrintWriter getWriter() {
    return(new PrintWriter(stringWriter));
  }

  /** Analogicznie, gdy zasoby wywoaj getOutputStream,
    * zwrcimy im strumie danych
    * stanowicy bufor danych wynikowych.
    */

  public ServletOutputStream getOutputStream() {
    return(new StringOutputStream(stringWriter));
  }

  /** Pobranie caego bufora w postaci obiektu String.
   *  <P>
   *  <I>Nie naley</I> wywoywa tej metody wicej ni jeden raz
   *  na tym samym obiekcie przechowujcym. API obiektu StringWriter
   *  nie gwarantuje, e poprzednia warto bdzie "pamitana",
   *  dlatego przy kadym wywoaniu moe by tworzony
   *  nowy obiekt String.
   */

  public String toString() {
    return(stringWriter.toString());
  }

  /** Pobranie obiektu StringBuffer. */

  public StringBuffer getBuffer() {
    return(stringWriter.getBuffer());
  }
}
